/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.dialog.AbstractTrendModel;
import DE.siemens.ad.logo.dialog.TrendModel;
import DE.siemens.ad.logo.dialog.TrendPanelModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;

public class GroupTrendModel
extends AbstractTrendModel
implements Observer {
    private boolean extremumChanged = false;
    private HashMap modelMap = new HashMap();

    GroupTrendModel(TrendPanelModel panelModel) {
        super(panelModel);
    }

    public void addTrendModel(TrendModel trendModel) {
        if (!trendModel.globalModel.equals(this.globalModel)) {
            System.err.println("Error!, different TrendPanelModel");
        }
        if (!this.modelMap.containsKey(trendModel.getName())) {
            this.modelMap.put(trendModel.getName(), trendModel);
            trendModel.addObserver(this);
        }
    }

    public void flushOneSample() {
        this.extremumChanged = false;
        Iterator iter = this.modelMap.values().iterator();
        while (iter.hasNext()) {
            ((TrendModel)iter.next()).flushOneSample();
        }
        if (this.extremumChanged) {
            this.updateRangeValue();
        }
    }

    public void update(Observable o, Object arg) {
        if (arg.equals(EXTREMUM_ATTR)) {
            this.extremumChanged = true;
        } else if (arg.equals(VISIBLITY_ATTR)) {
            this.visible = false;
            if (false) {
                this.visible = true;
            } else {
                this.visible = false;
                for (Object obj : this.modelMap.values()) {
                    if (!((AbstractTrendModel)obj).isVisible()) continue;
                    this.visible = true;
                    break;
                }
            }
            this.updateRangeValue();
        }
    }

    protected void updateRangeValue() {
        boolean isFirstTrend = true;
        Iterator iter = this.modelMap.values().iterator();
        double currMaxValue = 0.0;
        double currMinValue = 0.0;
        if (!this.isVisible()) {
            return;
        }
        while (iter.hasNext()) {
            TrendModel curve = (TrendModel)iter.next();
            if (!curve.isVisible()) continue;
            if (isFirstTrend) {
                currMaxValue = curve.maxSampleValue;
                currMinValue = curve.minSampleValue;
                isFirstTrend = false;
                continue;
            }
            if (curve.maxSampleValue > currMaxValue) {
                currMaxValue = curve.maxSampleValue;
            }
            if (!(curve.minSampleValue < currMinValue)) continue;
            currMinValue = curve.minSampleValue;
        }
        if (currMaxValue != this.maxSampleValue || currMinValue != this.minSampleValue) {
            this.maxSampleValue = currMaxValue;
            this.minSampleValue = currMinValue;
            super.updateRangeValue();
        }
        this.updateRangeValueToTrends();
    }

    private void updateRangeValueToTrends() {
        for (TrendModel model : this.modelMap.values()) {
            model.maxTickValue = this.maxTickValue;
            model.minTickValue = this.minTickValue;
        }
    }

    public void setVisible(boolean visible) {
        Iterator iter = this.modelMap.values().iterator();
        while (iter.hasNext()) {
            ((TrendModel)iter.next()).setVisible(true);
        }
        this.visible = visible;
    }

    public void setVisible(String trendName, boolean visible) {
        Object obj = this.modelMap.get(trendName);
        if (obj != null) {
            ((TrendModel)obj).setVisible(visible);
        }
        if (visible) {
            this.visible = true;
        } else {
            this.visible = false;
            Iterator iter = this.modelMap.values().iterator();
            while (iter.hasNext()) {
                if (!((TrendModel)iter.next()).isVisible()) continue;
                this.visible = true;
                break;
            }
        }
    }

    public boolean isVisible(String trendName) {
        Object obj = this.modelMap.get(trendName);
        if (obj != null) {
            return ((TrendModel)obj).isVisible();
        }
        System.err.println("Get visibility of bad trend name.");
        return false;
    }

    public Iterator getTrendModelIter() {
        return this.modelMap.values().iterator();
    }

    public TrendModel getTrendModel(String name) {
        return (TrendModel)this.modelMap.get(name);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.modelMap.values().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString()).append(',');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return "[" + sb.toString() + "]";
    }

    public void setSampleProd(int newSampleFreq) {
        if (newSampleFreq != this.globalModel.getSampleProd()) {
            Iterator iter = this.modelMap.values().iterator();
            if (!this.isVisible()) {
                return;
            }
            while (iter.hasNext()) {
                TrendModel curve = (TrendModel)iter.next();
                curve.setSampleProd(newSampleFreq);
            }
            this.updateRangeValue();
        }
    }

    public void clear() {
        for (Object obj : this.modelMap.values()) {
            ((AbstractTrendModel)obj).clear();
        }
    }
}

